/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;

public class ModifyFoodPower
extends Power {
    private final Predicate<ItemStack> applicableFood;
    private final List<AttributeModifier> foodModifiers;
    private final List<AttributeModifier> saturationModifiers;
    private final Consumer<Entity> entityActionWhenEaten;

    public ModifyFoodPower(PowerType<?> type, PlayerEntity player, Predicate<ItemStack> applicableFood, List<AttributeModifier> foodModifiers, List<AttributeModifier> saturationModifiers, Consumer<Entity> entityActionWhenEaten) {
        super(type, player);
        this.applicableFood = applicableFood;
        this.foodModifiers = foodModifiers;
        this.saturationModifiers = saturationModifiers;
        this.entityActionWhenEaten = entityActionWhenEaten;
    }

    public boolean doesApply(ItemStack stack) {
        return this.applicableFood.test(stack);
    }

    public void eat() {
        if (this.entityActionWhenEaten != null) {
            this.entityActionWhenEaten.accept((Entity)this.player);
        }
    }

    public List<AttributeModifier> getFoodModifiers() {
        return this.foodModifiers;
    }

    public List<AttributeModifier> getSaturationModifiers() {
        return this.saturationModifiers;
    }
}

